#ifndef _SQLIMPORT_CPP
#define _SQLIMPORT_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <SQL.H>
#include <SQLExt.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"
#include "../../SharedClasses/SQLClass/SQLClass.H"
#include "../../SharedClasses/SQLClass/SQLRoutines.H"

#include "../SockServer/SockServer.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "Command.H"
#include "SQLImport.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

SQLINTEGER CharTrim(SQLCHAR *Data, SQLINTEGER Length)
{
    SQLINTEGER Pos = Length;

    if(Length == 0)
        return Length;

    if(Data[Length-1] != ' ')
        return Length;

    Pos--;

    while(Pos != 0 && Data[Pos] == ' ')
        Pos--;

    if(Data[Pos] != ' ')
        Pos++;

    Data[Pos] = '\0';

    return Pos;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowDataColumbs(struct _SQLImportMembers *SIM, int ColumnCount)
{
    int ColumbPos = 0;
    while(ColumbPos < ColumnCount)
    {
        free(SIM->SingleRowData[ColumbPos]);
        SIM->SingleRowData[ColumbPos] = NULL;
        ColumbPos++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeColumbNames(struct _SQLImportMembers *SIM, int ColumnCount)
{
    int ColumbPos = 0;
    while(ColumbPos < ColumnCount)
    {
        free(SIM->ColumbNames[ColumbPos]);
        SIM->ColumbNames[ColumbPos] = NULL;
        ColumbPos++;
    }
    free(SIM->ColumbNames);
    SIM->ColumbNames = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void FreeSingleRowData(struct _SQLImportMembers *SIM)
{
    free(SIM->SingleRowData);
    SIM->SingleRowData = NULL;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ImportSQLResults(SocketServer *pSockSrvr, int iClient, char *InFileName)
{
    char StatusText[255];
    char SelectStatement[255];

    SQLINTEGER outDataLength = 0;
	SQLINTEGER outRowCount = 0;

    FILE *SourceHandle = NULL;

    _SQLImportMembers SIM;

    HSTMT StatementHandle = NULL;

	WriteLog(pSockSrvr->icClientID[iClient], "Importing client data.");

    if((SourceHandle = fopen(InFileName, "rb")) == NULL)
    {
        // FIXME: Need to dump the file name to log
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: TargetFile open error.");
        return false;
    }

    int TotalLengthOfAllColumbNames = 0; // For better memory management;
    int TotalLengthOfAllRowData = 0; // For better memory management
    int ImportTableNameLen = 0;
    SQLSMALLINT ColumnCount = 0;
    SQLINTEGER RowCount = 0;
    char ImportTable[256];

    fread(&ImportTableNameLen, sizeof(ImportTableNameLen), 1, SourceHandle); // Read import table name len
    fread(ImportTable, sizeof(char), ImportTableNameLen, SourceHandle); // Read import table name
    fread(&ColumnCount, sizeof(ColumnCount), 1, SourceHandle); // Read number of columbs
    fread(&RowCount, sizeof(RowCount), 1, SourceHandle);       // Read number of rows

    ImportTable[ImportTableNameLen] = '\0';

    char UniuqeKeyName[5][65];        // Contains the names of the uniuqe columbs
    int UniuqeKeyCol[5];              // Contains the columb position of the uniuqe columbs
    SQLINTEGER UniuqeKeysNeeded = 0;  // The ammount of uniuqe keys we have to find
    SQLUSMALLINT UniuqeKeysLoop = 0;    // Just used to loop through and get the data
    SQLINTEGER UniuqeKeysFound = 0;   // The ammount of uniuqe keys we have found

    sprintf(SelectStatement, "SELECT UniqueKeys, IKey1, IKey2, IKey3, IKey4, IKey5 FROM ImportKeys WHERE ImportTable = '%s'", ImportTable);
    if(!CCI[iClient].IndexDB.DBExecute(SelectStatement, &StatementHandle))
    {
        // FIXME: Need to dump the statement that failed to a seperate log file. (SelectStatement)
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: DBExecute failed on ImportKeys.");

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if(SQLRowCount(StatementHandle, &outRowCount) != SQL_SUCCESS)
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: SQLRowCount failed on ImportKeys.");

        DBCloseCursor(StatementHandle);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if(outRowCount != 1)
    {
        sprintf(StatusText, "Error in ImportSQLResultsFailed:: No or more than one uniuqe keys indexed for table: '%s'. Rows: %d.", ImportTable, outRowCount);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);

        DBCloseCursor(StatementHandle);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if(!DBFetch(StatementHandle))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: DBFetch failed on ImportKeys.");

        DBCloseCursor(StatementHandle);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if(!DBGetData(StatementHandle, 1, SQL_C_LONG, &UniuqeKeysNeeded, sizeof(UniuqeKeysNeeded), &outDataLength))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: DBGetData failed on UniuqeKeysNeeded.");

        DBCloseCursor(StatementHandle);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if(UniuqeKeysNeeded <= 0 || UniuqeKeysNeeded > 5)
    {
        sprintf(StatusText, "Error in ImportSQLResultsFailed:: No or too many uniuqe keys specified for table: '%s'.", ImportTable);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);

        DBCloseCursor(StatementHandle);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    // Get the names of all the uniuqe keys (Fill them in the UniuqeKeyName[] array)
    while(UniuqeKeysLoop < UniuqeKeysNeeded)
    {
        if(!DBGetData(StatementHandle, UniuqeKeysLoop+2, SQL_C_CHAR, UniuqeKeyName[UniuqeKeysLoop], 64, &outDataLength))
        {
			WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: DBGetData failed on UniuqeKeyName.");

            DBCloseCursor(StatementHandle);

            if(SourceHandle) fclose(SourceHandle);
            return false;
        }

        //CharTrim(UniuqeKeyName[UniuqeKeysLoop], outDataLength);
        UniuqeKeysLoop++;
    }

    DBCloseCursor(StatementHandle);

    SIM.ColumbNames = (char **) calloc(sizeof(char *), ColumnCount + 1);

    SQLSMALLINT ColNameLen = 0;

    int ColumbPos = 0;
    while(ColumbPos < ColumnCount)
    {
        fread(&ColNameLen, sizeof(ColNameLen), 1, SourceHandle);
        SIM.ColumbNames[ColumbPos] = (char *) calloc(sizeof(char), ColNameLen + 1);
        fread(SIM.ColumbNames[ColumbPos], sizeof(char), ColNameLen, SourceHandle);
        SIM.ColumbNames[ColumbPos][ColNameLen] = '\0';
        TotalLengthOfAllColumbNames = (TotalLengthOfAllColumbNames + ColNameLen);

        // Is this columb one of the uniuqe keys
        if(UniuqeKeysFound < UniuqeKeysNeeded)
        {
            int UniuqeKeyCount = 0;
            while(UniuqeKeyCount < UniuqeKeysNeeded)
            {
                if(strcmpi(UniuqeKeyName[UniuqeKeyCount], SIM.ColumbNames[ColumbPos]) == 0)
                {
                    UniuqeKeyCol[UniuqeKeyCount] = ColumbPos;
                    UniuqeKeysFound++;
                }
                UniuqeKeyCount++;
            }
        }

        ColumbPos++;
    }

	int UniuqeKeyCount = 0;
    while(UniuqeKeysNeeded < UniuqeKeysFound)
    {
        sprintf(StatusText, "Error in ImportSQLResultsFailed:: Required uniuqe keys wer not found for: '%s'.", ImportTable);
		WriteLog(pSockSrvr->icClientID[iClient], StatusText);

        FreeColumbNames(&SIM, ColumnCount);

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

    if( pSockSrvr->bcConnected[iClient] == false )
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Disconnected before data import.");

        if(SourceHandle) fclose(SourceHandle);
        return false;
    }

	WriteLog(pSockSrvr->icClientID[iClient], "Starting row by row data import.");

    SIM.SingleRowData = (char **) calloc(sizeof(char *), ColumnCount + 1);

    SQLINTEGER RowDataLen = 0;

    int RowPos = 0;
    while(RowPos < RowCount)
    {
        int BaseMemoryRequirement = 0;
        TotalLengthOfAllRowData = 0;

        // Get row data
        ColumbPos = 0;
        while(ColumbPos < ColumnCount)
        {
            fread(&RowDataLen, sizeof(RowDataLen), 1, SourceHandle);
            SIM.SingleRowData[ColumbPos] = (char *) calloc(sizeof(char), RowDataLen + 1);
            fread(SIM.SingleRowData[ColumbPos], sizeof(char), RowDataLen, SourceHandle);
            SIM.SingleRowData[ColumbPos][RowDataLen] = '\0';
            TotalLengthOfAllRowData = (TotalLengthOfAllRowData + RowDataLen);
            ColumbPos++;
        }

        BaseMemoryRequirement = ((TotalLengthOfAllColumbNames + TotalLengthOfAllRowData) + (ColumnCount * 5)) + 1024;

        char WhereStatement[1024];
        char CheckExistanceStatement[1024];

        // Assemble the where statement from the row data, the uniuqe key names and positions
        if(UniuqeKeysFound > 0)
        {
            // Assemble the where statement
            sprintf(WhereStatement, "WHERE %s = %s", UniuqeKeyName[0], SIM.SingleRowData[UniuqeKeyCol[0]]);
        	int UniuqeKeyCount = 1;
            while(UniuqeKeyCount < UniuqeKeysFound)
            {
                strcat(WhereStatement, " AND ");
                strcat(WhereStatement, UniuqeKeyName[UniuqeKeyCount]);
                strcat(WhereStatement, " = ");
                strcat(WhereStatement, SIM.SingleRowData[UniuqeKeyCol[UniuqeKeyCount]]);
                UniuqeKeyCount++;
            }

            // Assemble the check existance statement
            sprintf(CheckExistanceStatement, "SELECT %s", UniuqeKeyName[0]);
            strcat(CheckExistanceStatement, " FROM ");
            strcat(CheckExistanceStatement, ImportTable);
            strcat(CheckExistanceStatement, " ");
            strcat(CheckExistanceStatement, WhereStatement);
        }

		if(!CCI[iClient].CustDB.DBExecute(CheckExistanceStatement, &StatementHandle))
        {
            // FIXME: Need to dump the statement that failed to a seperate log file
			WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: DBExecute failed on CheckExistanceStatement.");

            FreeSingleRowDataColumbs(&SIM, ColumnCount);
            FreeSingleRowData(&SIM);
            FreeColumbNames(&SIM, ColumnCount);

            if(SourceHandle) fclose(SourceHandle);
            return false;
        }

        SQLINTEGER ReturnedRowCount = 0;

		if(SQLRowCount(StatementHandle, &ReturnedRowCount) != SQL_SUCCESS)
        {
            // FIXME: Need to dump the statement that returned these rows seperate log file. (CheckExistanceStatement)
			WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: Failed to retrieve row count.");

            DBCloseCursor(StatementHandle);

            FreeSingleRowDataColumbs(&SIM, ColumnCount);
            FreeSingleRowData(&SIM);
            FreeColumbNames(&SIM, ColumnCount);

            if(SourceHandle) fclose(SourceHandle);
            return false;
        }

        DBCloseCursor(StatementHandle);

        char *ImportStatement = NULL;
        bool FreeImportStatement = false;

        //----------------------------------------------------------------------------------------------
        if(ReturnedRowCount == 0) // Do insert
        {
            ImportStatement = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1);
            FreeImportStatement = true;

            sprintf(ImportStatement, "INSERT INTO %s (", ImportTable);

            ColumbPos = 0;
            while(ColumbPos < ColumnCount)
            {
                strcat(ImportStatement, SIM.ColumbNames[ColumbPos]);
                if(ColumbPos < ColumnCount - 1)
                {
                    strcat(ImportStatement, ",");
                }
                ColumbPos++;
            }
            strcat(ImportStatement, ") VALUES(");

            ColumbPos = 0;
            while(ColumbPos < ColumnCount)
            {
                strcat(ImportStatement, SIM.SingleRowData[ColumbPos]);
                if(ColumbPos < ColumnCount - 1)
                {
                    strcat(ImportStatement, ",");
                }
                ColumbPos++;
            }
            strcat(ImportStatement, ") ");
        }
        //----------------------------------------------------------------------------------------------
        else { // Do update
            BaseMemoryRequirement = (BaseMemoryRequirement + strlen(WhereStatement));
            ImportStatement = (char *) calloc( sizeof(char), BaseMemoryRequirement + 1);
            FreeImportStatement = true;

            sprintf(ImportStatement, "UPDATE %s SET ", ImportTable);

            ColumbPos = 0;
            while(ColumbPos < ColumnCount)
            {
                strcat(ImportStatement, SIM.ColumbNames[ColumbPos]);
                strcat(ImportStatement, "=");
                strcat(ImportStatement, SIM.SingleRowData[ColumbPos]);
                if(ColumbPos < ColumnCount - 1)
                {
                    strcat(ImportStatement, ",");
                }
                ColumbPos++;
            }

            strcat(ImportStatement, " ");
            strcat(ImportStatement, WhereStatement);
        }

        //----------------------------------------------------------------------------------------------

        if(ImportStatement != NULL)
        {
			if(!CCI[iClient].CustDB.DBExecute(ImportStatement, &StatementHandle))
            {
                // FIXME: Need to dump the statement that failed to a seperate log file. (ImportStatement)
				WriteLog(pSockSrvr->icClientID[iClient], "Error in ImportSQLResultsFailed:: DBExecute failed on ImportStatement.");

                FreeSingleRowDataColumbs(&SIM, ColumnCount);
                FreeSingleRowData(&SIM);
                FreeColumbNames(&SIM, ColumnCount);

                free(ImportStatement);

                if(SourceHandle) fclose(SourceHandle);
                return false;
            }

            DBCloseCursor(StatementHandle);
        }

        if(FreeImportStatement)
            free(ImportStatement);

        ImportStatement = NULL;

        FreeSingleRowDataColumbs(&SIM, ColumnCount);
        //FreeSingleRowData(&SIM); // This memory needs to stay intact untill we are done with the import

        ColumbPos++;

        RowPos++;

        if( pSockSrvr->bcConnected[iClient] == false )
        {
		    sprintf(StatusText, "Disconnected durring data import, after %d successful rows.", RowPos);
			WriteLog(pSockSrvr->icClientID[iClient], StatusText);

            FreeSingleRowData(&SIM);
            FreeColumbNames(&SIM, ColumnCount);

            if(SourceHandle) fclose(SourceHandle);
            return false;
        }
    }

    sprintf(StatusText, "Successfully imported %d client data rows.", RowPos);
	WriteLog(pSockSrvr->icClientID[iClient], StatusText);

    FreeSingleRowData(&SIM);
    FreeColumbNames(&SIM, ColumnCount); 

    if(SourceHandle) fclose(SourceHandle);

    return true;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
